PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144440469"
 Author = "jayas.jayas"
 Desc = "Single Line using Protection Circuit"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 1144440458
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([810,72],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,666,1062]
    Posn = [810,72]
    Icon = [-1,-1]
    Extents = 0,0,666,1062
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,666,255],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(23227456,"V2a",8388608,,,)
     Curve(63439184,"V2b",32768,,,)
     Curve(25482520,"V2c",128,,,)
     }
    Graph([0,255],[0,0,666,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(46297632,"I2a",8388608,,,)
     Curve(46299440,"I2b",32768,,,)
     Curve(23133400,"I2c",128,,,)
     }
    Graph([0,509],[0,0,666,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(23139016,"I20",8388608,,,)
     }
    PGraph([0,763],[0,0,666,236],"PolyGraph")
     {
     Options = 2
     Curve(46664728,"Br2a",8388608,,,1)
     Curve(63065480,"Br2b",32768,,,1)
     Curve(23567968,"Br2c",128,,,1)
     }
    }
   -Plot-([72,72],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,666,1062]
    Posn = [72,72]
    Icon = [-1,-1]
    Extents = 0,0,666,1062
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,666,255],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(23156304,"V1a",8388608,,,)
     Curve(23570360,"V1b",32768,,,)
     Curve(23225464,"V1c",128,,,)
     }
    Graph([0,255],[0,0,666,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(23154312,"I1a",8388608,,,)
     Curve(25424704,"I1b",32768,,,)
     Curve(25375320,"I1c",128,,,)
     }
    Graph([0,509],[0,0,666,254],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(23136488,"I10",8388608,,,)
     }
    PGraph([0,763],[0,0,666,236],"PolyGraph")
     {
     Options = 2
     Curve(46661704,"Br1a",8388608,,,1)
     Curve(63063576,"Br1b",32768,,,1)
     Curve(25475776,"Br1c",128,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144440458
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Input("FType",36,-18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([72,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,198,198,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(25404736)
    Dial(23176440)
    Slider(23428016)
    Slider(23596520)
    Slider(45229080)
    }
   -Wire-([1260,846],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1368,1044],6,0,-1)
    {
    Name = "B2"
    }
   0.export([1422,1134],4,0,210)
    {
    Name = "F"
    }
   0.datalabel([990,684],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([990,738],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([990,792],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([954,684],0,23477336,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.31"
    Units = "s"
    Collect = "1"
    }
   0.var([954,738],0,22751792,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   0.var([954,792],0,22752328,70)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.31"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([954,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,198,1062,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1260,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([990,846],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1206,666],4,0,130)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -ControlPanel-([954,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(23687832)
    Slider(23477336)
    Slider(22751792)
    }
   -Wire-([612,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([648,756],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([612,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([648,810],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([774,792],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1332,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1332,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([954,846],0,25521640,90)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([954,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(23670584)
    Slider(22752328)
    Slider(25521640)
    }
   0.tbreakn([1206,846],4,0,100)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.logic([1296,846],6,0,160)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1224,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([504,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 504,108,666,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.logic([1296,666],0,0,170)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1332,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1332,630],0,23687832,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1440,666],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1332,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([954,558],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,558,1116,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1332,792],6,23670584,80)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1368,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1440,810],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1404,810],0,0,190)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1404,666],6,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([1098,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 1098,1044,1206,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datamerge([1386,1098],4,0,200)
    {
    N = "3"
    Type = "1"
    Disp = "1"
    }
   -Wire-([1332,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1260,1062],0,23643840,110)
    {
    Name = "Enable"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "Time"
    Toff = "Prot"
    }
   0.datalabel([1368,1026],6,0,-1)
    {
    Name = "B1"
    }
   0.export([1422,1098],4,0,220)
    {
    Name = "B"
    }
   -Wire-([1260,702],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1188,756],0,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.import([1116,756],0,0,60)
    {
    Name = "FType"
    }
   0.datalabel([1350,1062],6,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([1152,792],4,0,-1)
    {
    Name = "Enable"
    }
   0.tfaultn([738,792],4,0,140)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(23253000)
    Meter(25576944)
    Meter(25578936)
    Slider(23254864)
    Meter(23404992)
    Meter(25569184)
    Meter(25570896)
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(23256824)
    Meter(25572824)
    Meter(25574952)
    Slider(23258800)
    Meter(23158296)
    Meter(45231904)
    Meter(45233896)
    }
   0.arrow_a([504,216],1,0,-1)
    {
    }
   0.var([576,756],0,23428016,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.3"
    Units = "s"
    Collect = "1"
    }
   0.var([576,810],0,23596520,50)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   -Sticky-([36,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,900,162,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source 
          and B1
  2=> FT2:
          Between Line 
          and B1
  3=> FT3:
          Between Line 
          and B2
  4=> FT4:
          Between Source
          and B2"
    }
   -Sticky-([180,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,900,288,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No Fault
11=> No fault (0)"
    }
   -ControlPanel-([342,864],0)
    {
    Name = "CPanel"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Switch(23643840)
    }
   -Sticky-([756,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,108,864,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -ControlPanel-([756,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(23312192)
    Slider(25479040)
    }
   -Sticky-([756,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,450,918,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT
 record data.

You can turn on or off 
each recorder individually."
    }
   -ControlPanel-([756,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(23317760)
    Switch(25552632)
    }
   0.unity([1332,1062],0,0,120)
    {
    IType = "2"
    OType = "1"
    }
   -Divider-([18,630],0)
    {
    Size(918,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([936,90],0)
    {
    Size(0,1116)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([702,90],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Prot_2")
  {
  Desc = ""
  FileDate = 1144440458
  Nodes = 
   {
   Input("Control",0,-54)
    {
    Type = Integer
    Dim  = [3]
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("B",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Line")
   Text(0,4,"Protection")
   Text(0,15,"Stn 2")
   Pen(ByNode,ByNode,ByNode,Control)
   Line(0,-54,0,-29)
   Pen(,Solid)
   Line(0,-29,-6,-35)
   Line(0,-29,6,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,B)
   Line(54,0,29,0)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Wire-([432,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([450,522],1,23395048,330)
    {
    Name = "B1Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([432,486],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([630,486],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([702,828],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([810,630],0,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1296,342],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([540,378],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([540,342],0,0,10)
    {
    }
   -Wire-([684,342],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([774,342],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.compar([576,342],0,0,160)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([846,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([954,558],0,0,100)
    {
    INTR = "0"
    }
   0.logic([1026,594],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([954,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,594],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1062,594],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1062,630],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1062,612],0,23054128,310)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([666,666],6,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([432,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,828],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -ControlPanel-([1062,270],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(23434376)
    }
   0.datatap([936,558],0,0,90)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.import([882,540],0,0,80)
    {
    Name = "Control"
    }
   -Wire-([936,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1314,594],2,0,300)
    {
    Name = "B"
    }
   0.datalabel([504,522],0,0,-1)
    {
    Name = "B2testa"
    }
   0.pgb([450,486],3,22967728,340)
    {
    Name = "B2aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([432,702],1,22969600,290)
    {
    Name = "B2Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,666],3,22893704,320)
    {
    Name = "B2bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,828],3,23745632,280)
    {
    Name = "B2cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([432,864],1,23050552,270)
    {
    Name = "B2Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([468,864],0,0,-1)
    {
    Name = "B2testc"
    }
   0.datalabel([1296,342],0,0,-1)
    {
    Name = "B2opT"
    }
   0.bin_delay([918,630],0,0,240)
    {
    T = "B2opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   0.var([1206,342],0,23434376,30)
    {
    Name = "B2opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   0.logic([738,666],0,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([270,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([162,468],0,0,40)
    {
    Name = "V"
    }
   -Wire-([198,468],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.import([162,504],0,0,60)
    {
    Name = "I"
    }
   -Wire-([198,504],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([234,810],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([234,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([234,468],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([432,666],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.datalabel([468,702],0,0,-1)
    {
    Name = "B2testb"
    }
   -Wire-([432,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([918,540],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   0.datatap([1152,558],0,0,110)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1152,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1206,558],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.logic([1242,594],0,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   0.datatap([324,486],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,522],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,702],0,0,130)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,828],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,864],0,0,150)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,666],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([270,504],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.block_avg([360,828],0,0,210)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([360,486],0,0,180)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([360,666],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.unity([684,342],0,0,170)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 Module("Prot_1")
  {
  Desc = ""
  FileDate = 1144440458
  Nodes = 
   {
   Input("Control",0,-54)
    {
    Type = Integer
    Dim  = [3]
    }
   Input("V",-54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I",-54,18)
    {
    Type = Real
    Dim  = [4]
    }
   Output("B",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-29,29,29)
   Text(0,-7,"Line")
   Text(0,4,"Protection")
   Pen(ByNode,ByNode,ByNode,Control)
   Line(0,-54,0,-29)
   Pen(,Solid)
   Line(0,-29,-6,-35)
   Line(0,-29,6,-35)
   Pen(,ByNode,,V)
   Line(-54,-18,-29,-18)
   Pen(,Solid)
   Line(-29,-18,-35,-11)
   Line(-29,-18,-35,-24)
   Pen(,ByNode,,I)
   Line(-54,18,-29,18)
   Pen(,Solid)
   Line(-29,18,-35,24)
   Line(-29,18,-35,11)
   Pen(,ByNode,,B)
   Line(54,0,29,0)
   Text(0,15,"Stn 1")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.pgb([432,378],3,22812944,340)
    {
    Name = "B1aprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([414,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([414,594],1,22815424,290)
    {
    Name = "B1Test"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([450,594],0,0,-1)
    {
    Name = "B1testb"
    }
   0.datalabel([486,414],0,0,-1)
    {
    Name = "B1testa"
    }
   0.pgb([432,720],3,23271168,280)
    {
    Name = "B1cprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([432,558],3,23326672,320)
    {
    Name = "B1bprot"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([414,378],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([612,378],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([684,720],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.logic([792,522],0,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1098,288],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.const([522,270],0,0,20)
    {
    Name = ""
    Value = ".1"
    }
   0.time-sig([522,234],0,0,10)
    {
    }
   -Wire-([666,234],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([756,234],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.datalabel([1098,288],0,0,-1)
    {
    Name = "B1opT"
    }
   0.compar([558,234],0,0,160)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([828,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.inv([936,450],0,0,100)
    {
    INTR = "0"
    }
   0.logic([1008,486],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([936,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,486],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1044,486],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1044,522],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1044,504],0,23245984,310)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([450,756],0,0,-1)
    {
    Name = "B1testc"
    }
   -Wire-([414,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,720],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.pgb([414,756],1,23588064,270)
    {
    Name = "B1Testc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datatap([306,378],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,414],0,0,70)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([252,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([306,558],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,594],0,0,130)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([252,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([306,720],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,756],0,0,150)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([918,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.export([1296,486],2,0,300)
    {
    Name = "B"
    }
   -Sticky-([216,900],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,900,468,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Positive sequence impedance of Tline
   R = 14.5536 ohm
   X = 78.1537 ohm

Z = 79.5 / 80 deg.

Set  protection  to be 85% or  67 ohm @ 80 deg.

Station 2 set to over reach by 7%, ie 85 ohm."
    }
   -ControlPanel-([864,216],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(23735280)
    }
   -Wire-([414,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,558],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.bin_delay([900,522],0,0,240)
    {
    T = "B1opT"
    Toff = "1.00 [s]"
    INITST = "0"
    INTR = "0"
    }
   0.import([144,360],0,0,30)
    {
    Name = "V"
    }
   -Wire-([180,360],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.import([144,396],0,0,60)
    {
    Name = "I"
    }
   -Wire-([180,396],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([216,702],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;0,342"
    }
   0.datatap([918,450],0,0,90)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.import([864,432],0,0,80)
    {
    Name = "Control"
    }
   -Wire-([900,432],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.datatap([1116,450],0,0,110)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1116,450],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1188,450],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.logic([1224,486],0,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([648,558],6,0,200)
    {
    Type = "2"
    Inv = "0"
    }
   0.pgb([432,414],1,23733288,330)
    {
    Name = "B1Int"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.var([1008,288],0,23735280,40)
    {
    Name = "B1opT"
    Group = ""
    Display = "0"
    Max = ".1"
    Min = "0.0"
    Value = "0.05"
    Units = ""
    Collect = "1"
    }
   0.block_avg([342,720],0,0,210)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86deg"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([342,558],0,0,190)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "45 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.block_avg([342,378],0,0,180)
    {
    Fmt = "0"
    Freq = "$(f)"
    Imp = "46 [ohm]"
    Ph = "86 [deg]"
    R = "10.0 [ohm]"
    X = "80.0 [ohm]"
    }
   0.logic([720,558],0,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   0.unity([666,234],0,0,170)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144440458
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([954,576],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([774,576],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([558,576],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([360,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([540,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([792,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([972,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([990,1080],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([990,1116],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([990,1152],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1116,1080],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1116,1116],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1152,1080],0,46297632,670)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1152,1116],0,46299440,590)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1026,1026],0,23225464,290)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1152,954],0,23227456,190)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1152,990],0,63439184,250)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1278,954],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1278,990],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1278,1026],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1314,954],0,46661704,750)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1404,954],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1404,990],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1440,954],0,46664728,740)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1440,1026],0,23567968,690)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1278,1080],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1026,990],0,23570360,230)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1314,990],0,63063576,730)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1440,990],0,63065480,720)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1026,1116],0,25424704,610)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.datalabel([522,846],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([558,846],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([594,846],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([522,1026],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([558,1026],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([594,1026],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([954,918],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([972,954],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([972,990],0,0,220)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([954,918],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([990,954],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([990,990],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1116,990],2,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([414,846],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([450,846],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([486,846],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([414,1026],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([450,1026],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([486,1026],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([414,450],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([918,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([342,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([360,954],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([360,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([1152,1026],0,25482520,310)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1278,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1152],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1278,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1188],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1404,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1188],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1116,954],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1404,1152],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1404,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1116],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1404,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1080],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1404,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1026],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1116,1152],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1116,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,1026],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1098,1026],0,0,300)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1098,990],0,0,240)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1098,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([990,1026],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([972,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([972,1026],0,0,280)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1278,1116],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1314,1026],0,25475776,700)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([1098,954],0,0,170)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1080,918],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1080,918],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([288,954],0,25479040,100)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1422,558],2,0,400)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1026,1080],0,23154312,680)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1026,954],0,23156304,160)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1440,846],0,23158296,110)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1440,882],0,23404992,130)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1386,558],2,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([378,576],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([810,864],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([846,864],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([918,864],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([378,594],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([810,1116],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([774,594],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([954,594],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([918,1116],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1404,630],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([864,1026],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,594],0,0,-1)
    {
    Name = "F2"
    }
   0.breaker3([882,450],0,0,440)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "18.5 [MW]"
    Q = "249.8 [MVAR]"
    }
   0.pgb([1026,1152],0,25375320,570)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1152,1152],0,23133400,550)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   -Wire-([1116,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([990,1188],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([1026,1188],0,23136488,530)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.2"
    Max = "0.2"
    }
   0.datalabel([1116,1188],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1152,1188],0,23139016,510)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0e-006"
    Max = "7.0e-006"
    }
   0.datatap([810,864],6,0,810)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([846,864],6,0,800)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([882,864],6,0,790)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([918,864],6,0,780)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([882,864],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([792,1098],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datatap([810,1116],0,0,660)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([918,1116],0,0,630)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([846,1116],0,0,-1)
    {
    Name = "F2"
    }
   0.datatap([846,1116],0,0,650)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([882,1116],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([756,990],0,25404736,180)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "4"
    Value = "2"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([828,990],0,0,200)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([864,990],4,0,360)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([828,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([864,954],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([792,882],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.mux_array([846,918],0,0,760)
    {
    DPath = "0"
    }
   0.breaker3([450,450],4,0,420)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05205 [MW]"
    Q = "0.2254 [MVAR]"
    }
   0.mux_array([846,1062],6,0,480)
    {
    DPath = "0"
    }
   0.datalabel([864,990],5,0,-1)
    {
    Name = "FType"
    }
   0.datalabel([648,1098],2,0,-1)
    {
    Name = "I1"
    }
   -Wire-([666,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([666,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([1188,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,810,1296,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.datamerge([648,972],6,0,450)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   -Wire-([666,1026],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([666,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([648,954],2,0,-1)
    {
    Name = "I2"
    }
   -Wire-([666,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([684,882],0,0,-1)
    {
    Name = "B2x"
    }
   0.datalabel([648,828],2,0,-1)
    {
    Name = "Control"
    }
   0.datatap([1332,558],2,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "0"
    }
   0.datalabel([1386,558],6,0,-1)
    {
    Name = "B1x"
    }
   0.datalabel([1422,558],6,0,-1)
    {
    Name = "B2x"
    }
   0.datalabel([1332,558],6,0,-1)
    {
    Name = "Enable"
    }
   0.datalabel([1422,252],0,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1422,288],0,0,-1)
    {
    Name = "I1"
    }
   0.datatap([882,1116],0,0,640)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1530,270],0,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1476,216],2,0,-1)
    {
    Name = "Control"
    }
   0.datalabel([1476,342],2,0,-1)
    {
    Name = "Control"
    }
   0.datalabel([1422,414],0,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1530,396],0,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1422,378],0,0,-1)
    {
    Name = "V2"
    }
   -Wire-([666,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,900],0,0,-1)
    {
    Name = "B1x"
    }
   0.datalabel([702,864],0,0,-1)
    {
    Name = "Enable"
    }
   0.var([1044,522],5,23253000,50)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1098,522],5,23254864,60)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([288,522],3,23256824,40)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([234,522],3,23258800,30)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([1062,450],2,0,340)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([270,450],6,0,330)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.recorder2_0([486,1098],0,0,710)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([594,990],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([342,558],0,0,850)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([522,558],0,0,840)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.tpflt([810,558],4,0,830)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([990,558],4,0,820)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([864,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([594,1170],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([882,1170],0,0,-1)
    {
    Name = "Ron"
    }
   0.annotation([828,1152],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.var([828,1170],0,45229080,320)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "1e-3"
    Value = "0.001"
    Units = ""
    Collect = "1"
    }
   0.datamerge([648,828],6,0,410)
    {
    N = "3"
    Type = "1"
    Disp = "1"
    }
   0.datamerge([648,1116],6,0,430)
    {
    N = "4"
    Type = "2"
    Disp = "1"
    }
   0.pgb([1314,1080],0,45231904,620)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1116],0,45233896,580)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1080],0,25569184,600)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1116],0,25570896,560)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1152],0,25572824,540)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1188],0,25574952,500)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1152],0,25576944,520)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1188],0,25578936,490)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.datalabel([666,1044],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([720,990],0,0,-1)
    {
    Name = "I20"
    }
   0.datalabel([684,1026],0,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([702,1008],0,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([666,1188],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([684,1170],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([702,1152],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([720,1134],0,0,-1)
    {
    Name = "I10"
    }
   -Sticky-([1152,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 1152,432,1242,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Prot_1([1476,270],0,0,470)
    {
    }
   .Prot_2([1476,396],0,0,460)
    {
    }
   0.var_pot([936,990],2,23176440,210)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Wire-([666,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.recorder2_0([486,918],0,0,770)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([144,954],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.const([108,918],0,0,90)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([18,1008],0,23312192,120)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.select([180,918],6,0,350)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([216,918],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([54,954],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([324,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([54,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([54,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([342,1098],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.select([180,1098],6,0,270)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([108,1098],0,0,260)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([144,1134],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.var_switch([180,846],1,23317760,80)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([180,1026],1,25552632,140)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   .Controls([1512,612],4,0,370)
    {
    }
   0.datalabel([1404,594],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1350,576],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1476,594],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1476,630],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,18,522,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Four fault positions for full fault control ahead and behind station relays.
- Two breakers are controlled by a manual Control switch, breaker timers or breaker protection 
  The Control page defines the users controls.   (Default Breaker Position is closed).
- Independent breaker pole tripping is possible."
    }
   -TLine-([558,450],0,111801496,-1)
    {
    Name = "LINE1"
    Date = 1144440459
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FrePhase_Options([216,468],0,111833096,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Ground([630,702],0,111767560,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,198],0,111767872,-1)
      {
      Mode = "1"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([702,612],0,111898680,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([810,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([72,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,432,162,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Plots_B1([1512,522],0,0,70)
    {
    }
   -Sticky-([612,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,36,1008,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. Select Global Substitutions under Project Settings.  In this window, change the value of f to the desired frequency. Also make sure appropriate frequency is selected in the RTP/COMTRADE blocks.
"
    }
   0.multimeter([504,450],0,0,10)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([828,450],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([1404,846],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1404,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,882],0,0,-1)
    {
    Name = "V2rms"
    }
   -Divider-([18,738],0)
    {
    Size(1530,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 }

